//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12P128.h>     /* derivative information */
#include "target.h" 
#include "S12P_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

#pragma CONST_SEG PPAGE08
const char Window8[56] = "08 PPAGE 08 PPAGE 08 PPAGE 08 PPAGE 08 PPAGE 08 PPAGE 08";
#pragma CONST_SEG PPAGE09
const char Window9[56] = "09 PPAGE 09 PPAGE 09 PPAGE 09 PPAGE 09 PPAGE 09 PPAGE 09";
#pragma CONST_SEG PPAGE0A
const char WindowA[56] = "0A PPAGE 0A PPAGE 0A PPAGE 0A PPAGE 0A PPAGE 0A PPAGE 0A";
#pragma CONST_SEG PPAGE0B
const char WindowB[56] = "0B PPAGE 0B PPAGE 0B PPAGE 0B PPAGE 0B PPAGE 0B PPAGE 0B";

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
unsigned char LED_Flag;

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT
void Wait1ms(void);
void WaitNms(int);
void Delay(unsigned int);
void ConfigurePorts(void);

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {

   while(1)
   {
       PPAGE = 0x08;
       asm BGND;
       PPAGE = 0x09;
       asm BGND;
       PPAGE = 0x0A;
       asm BGND;
       PPAGE = 0x0B;
       asm BGND;
   }
}

/******************************************************************************
Function Name	:	Wait1ms
Engineer		:	
Date			:	02/06/00

Parameters		:	none
Returns			:	none
Notes			:	Waits 1mS. 
******************************************************************************/

void Wait1ms(void){
   asm {  
     LDX #CONST
     loop:
     DEX     ;1 cycles
     CPX #0  ;2 cycles
     BNE loop ;3 cycles              
   }     
}

/******************************************************************************
Function Name	:	WaitNms
Engineer		:	
Date			:	02/06/00

Parameters		:	int
Returns			:	none
Notes			:	Waits for N mS. 
******************************************************************************/

void WaitNms(int n){
   int i;
   for(i=1;i<=n;i++) Wait1ms();
}

/******************************************************************************
Function Name	:	Delay
Engineer		   :	r32151
Date			   :	02/06/00
Parameters		:	unsigned int delayTime
Returns			:	NONE
Notes			   :	Simple software delay dependent on CPU clock frequency and
					   compile strategy 
******************************************************************************/
void Delay(unsigned int delayTime)					
{
   unsigned int x;						 /*outer loop counter */
  	char y;									 /*inner loop counter */

  	for (x=0; x<delayTime; x++)
  	{	
  		for (y=0; y<100; y++)
  		{} 
	}
}

/******************************************************************************
Function Name	:	ConfigurePorts
Engineer		   :	r32151, updated b06320/r28318
Date			   :	01/03/05, updated 09/06/09
Headers			: 	target.h
Parameters		:	NONE
Returns			:	NONE
Notes			   :	Code to set up i/o ports 
******************************************************************************/
void ConfigurePorts(void)
{

/******* CORE PORTS ********/

/* core interrupts */
/* This register register was renamed. On early D, A and H families it is called INTCR,
   on all other families it is called IRQCR. */
	IRQCR = 0;		/* IRQ only responds to falling edge  */
								/*	- note IRQE is write once */								

/*include this line to clear the X-bit in order to enable the XIRQ function */   
//  asm ANDCC #~BIT6;	

/* drive level */
	RDRIV = ALL_REDUCED_DRIVE;						/* core ports reduced drive */
/* Enable Pull devices */
	PUCR 	= ALL_PULLS_ON; 							/* Note: only pull-ups available on core ports */
						  						/* some port E pins require care when using external pull devices*/
						  						/* port E.7: pull up for LC Pierce, tie low for ext osc or full Pierce, */
						  						/*           reset enables internal pull up.                     */
						  						/* port E.5 & E.6 should be pulled down for single chip use      */
						  						/*           reset enables internal pull down.                   */
/* configure port data and direction */
/* PORT A */
	PORTA = ALL_LOW;	   
//	DDRA = ALL_OUTPUTS;
  DDRA = 0x0F;
/* PORT B */
	PORTB = ALL_HIGH;	   					
	DDRB = ALL_OUTPUTS; 					    
/* PORT E */
	PORTE = ALL_LOW;	   
	DDRE = ALL_INPUTS; 		
/******* PIM PORTS ********/

/* PORT T */
/* Configure Pull-polarity */
	PPST 	= ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERT 	= ALL_PULLS_ON;
/* drive level */
	RDRT 	= ALL_REDUCED_DRIVE;
/* port data */
	PTT 	= ALL_LOW;   
/* port direction */
	DDRT 	= ALL_INPUTS;

/* PORT S */
/* Configure Pull-polarity */
	PPSS 	= ALL_PULLED_DOWN;
/* Enable Pull devices */

/* Enable Pull devices */
	PERS 	= ALL_PULLS_ON;					
//	PERS.byte 	= BIT7|BIT6|BIT5|BIT4;					/* S12 EVB - no pull devices on port S0-3 due to avoid */ 
																	/* conflict with connections to RS232 transceiver */
/* drive level */
	RDRS 	= ALL_REDUCED_DRIVE;
/* Configure wired-or outputs */
	WOMS 	= 0x00;
/* port data */
	PTS 	= ALL_LOW;	   
/* port direction */
	DDRS 	= ALL_INPUTS;
	
/* PORT M */
/* Configure Pull-polarity */
	PPSM = ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERM 	= ALL_PULLS_ON; 	
//	PERM.byte 	= BIT7|BIT6|BIT5|BIT4|BIT3|BIT2|BIT1; 	/* S12 EVB - no pull device enebled on port M0 as it's */
																  	   /*driven by the CAN transceiver Rx pin */
/* drive level */
	RDRM 	= ALL_REDUCED_DRIVE;
/* Configure wired-or outputs */
	WOMM 	= 0x00;	   
/* port data */
	PTM 	= ALL_LOW;	   
/* port direction */
	DDRM 	= ALL_INPUTS;
	
/* PORT P */
/* Configure Pull-polarity */
	PPSP 	= ALL_PULLED_UP;
/* Enable Pull devices */
	PERP 	= ALL_PULLS_ON;
/* drive level */
	RDRP 	= ALL_REDUCED_DRIVE;						
/* port data */
	PTP 	= ALL_LOW;		   
/* port direction */
	DDRP 	= ALL_INPUTS;     
/* Clear all interrupt flags */
	PIFP 	= 0xFF;
/* Enable interrupts */
//	PIEP 	= 0x00;
	PIEP 	= 0x03;
	

/* PORT J */
/* Configure Pull-polarity */
	PPSJ 	= ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERJ 	= ALL_PULLS_ON;
/* drive level */
	RDRJ 	= ALL_REDUCED_DRIVE;
/* port data */
	PTJ 	= ALL_LOW;	   
/* port direction */
	DDRJ 	= BIT_7 | BIT_6 ;	 /* two debug outputs */
/* Clear all interrupt flags */
	PIFJ 	= 0xFF;
/* Enable interrupts */
	PIEJ 	= 0x00;
	


/******* ATD PORTS ********/
/* In order to use the digital input function the ATDIEN bit needs to be set */
/* ! NOTE: ATD port pull-ups are active for both digital and analog inputs ! */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/	

/*for PAD[7:0] */	
   PER0AD 	= ALL_PULLS_OFF;     /* Port AD0 Pull-up Enable */
	 ATDDIEN  = 0x00;				/* 1 = digital input enabled */
   RDR1AD 	= ALL_REDUCED_DRIVE; /* Port AD0 Reduced Drive Register 1 */
   PT1AD 	  = ALL_LOW;	         /* Port AD0 I/O Register 1 */
   DDR1AD 	= ALL_INPUTS;        /* Port AD0 Data Direction Register 1 */

/*for PAD[15:8] */  
   PER1AD 	= ALL_PULLS_OFF;     /* Port AD1 Pull-up Enable */
	 ATDDIEN  = 0x00;				/* 1 = digital input enabled */
   RDR0AD 	= ALL_REDUCED_DRIVE; /* Port AD1 Reduced Drive Register 1 */
   PT0AD   	= ALL_LOW;	         /* Port AD1-1 I/O Register 1 */
   DDR0AD 	= ALL_INPUTS;        /* Port AD1 Data Direction Register 0 */	


 /***** ECKL options *****/
 
/* ECLK available on PortE.4, ECLKx2 available on Port E.7 
    - note, keeping port E configured for reduced drive 
		 will minimise ECLK generated noise */							
#ifdef ECLK_OUT
// ECLKDIV = 1 to 32; DEFINED IN TARGET.H 
/* select one: */
//   ECLKCTL = ECLKCTL_NCLKX2_MASK|ECLKCTL_NECLK_MASK;              /* ECLKx2 off. ECLK              off */
//   ECLKCTL = ECLKCTL_NECLK_MASK;                                  /* ECLKx2 on.  ECLK              off */
   ECLKCTL = (ECLKCTL_NCLKX2_MASK|(ECLKDIV-1));                     /* ECLKx2 off. ECLK/ECLKDIV       on */
//   ECLKCTL = ECLKCTL_NCLKX2_MASK|(ECLKDIV-1)|ECLKCTL_DIV16_MASK;  /* ECLKx2 off. ECLK/(ECLKDIV*16)  on */
//   ECLKCTL = (ECLKDIV-1);                                         /* ECLKx2 on.  ECLK/(ECLKDIV)     on */
//   ECLKCTL = (ECLKDIV-1)|ECLKCTL_DIV16_MASK;                      /* ECLKx2 on.  ECLK/(ECLKDIV*16)  on */


#endif
}

/******************************************************************************
Function Name	:	PORTP_ISR
Engineer		:	G.Borland
Date			:	15/06/09
Parameters		:	NONE
Returns			:	NONE
Notes			:	Interrupt service routine for PORTP module.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
interrupt void PORTP_ISR(void)
{
  /* Clear all interrupt flags */
  	PIFP 	= 0x03;
    if ((PTP & 0x03) == 0x02) LED_Flag = 1;
    else LED_Flag = 0;
} 

#pragma CODE_SEG DEFAULT